package com.proandroidflash {
	import flash.events.TransformGestureEvent;
	import flash.geom.Point;
	import flash.ui.Multitouch;
	import flash.ui.MultitouchInputMode;
	import mx.events.ResizeEvent;
	import spark.components.Image;

	public class MultitouchImage extends Image {
		public function MultitouchImage() {
			addEventListener(ResizeEvent.RESIZE, resizeListener);
			addEventListener(TransformGestureEvent.GESTURE_ROTATE, rotateListener);
			addEventListener(TransformGestureEvent.GESTURE_ZOOM, zoomListener);
			Multitouch.inputMode = MultitouchInputMode.GESTURE;
		}
		
		protected function resizeListener(e:ResizeEvent):void {
			transformX = width/2;
			transformY = height/2;
		}
		
		protected function rotateListener(e:TransformGestureEvent):void {
			rotation += e.rotation;
		}
		
		protected function zoomListener(e:TransformGestureEvent):void {
			scaleX *= e.scaleX;
			scaleY *= e.scaleY;
		}
	}
}